// routes/usuariosRoutes.js
const express = require("express");
const router = express.Router();
const usuariosController = require("../controllers/usuariosController");
const { verificarPermiso } = require("../middleware/permisosMiddleware");

// 🧪 Ruta de prueba
router.get("/test", (req, res) => {
  res.send("Ruta de usuarios funcionando correctamente ✅");
});

// 📋 Obtener todos los usuarios
router.get("/", verificarPermiso("usuarios"), usuariosController.getUsuarios);

// ➕ Crear usuario
router.post("/", verificarPermiso("usuarios"), usuariosController.createUsuario);

// ✏️ Actualizar usuario
router.put("/:id", verificarPermiso("usuarios"), usuariosController.updateUsuario);

// 🗑️ Eliminar usuario
router.delete("/:id", verificarPermiso("usuarios"), usuariosController.deleteUsuario);

module.exports = router;
