// routes/responsablesRoutes.js
const express = require("express");
const router = express.Router();
const responsablesController = require("../controllers/responsablesController");

// Ruta de prueba rápida
router.get("/test", (req, res) => {
  res.send("Ruta de responsables detectada correctamente ✅");
});

// CRUD responsables
router.get("/", responsablesController.getResponsables);
router.get("/cargos", responsablesController.getCargos);
router.post("/", responsablesController.createResponsable);
router.put("/:id", responsablesController.updateResponsable);
router.delete("/:id", responsablesController.deleteResponsable);

module.exports = router;
