// middleware/permisosMiddleware.js
// REEMPLAZA TU ARCHIVO CON ESTE CÓDIGO

const permisosPorRol = {
  Administrador: [
    "activos",
    "monitoreo",
    "responsables",
    "simulacros",
    "incidentes",
    "usuarios",
    "caidas",
    "reportes"
  ],
  "Responsable TI": [
    "activos",
    "monitoreo",
    "simulacros",
    "incidentes",
    "caidas",
    "reportes"
  ],
  Consulta: ["monitoreo", "reportes", "activos"],
};

exports.verificarPermiso = (modulo) => {
  return (req, res, next) => {

    // 🔥 CAMBIO PRINCIPAL:
    // Ya no leemos de req.headers. Leemos de req.usuario
    // que fue agregado por el middleware 'verificarToken'
    const rol = req.usuario.rol; 

    if (!rol) {
      return res.status(401).json({ error: "Rol no encontrado en el token del usuario" });
    }

    const permisos = permisosPorRol[rol];

    if (!permisos || !permisos.includes(modulo)) {
      // Error 403 - Prohibido. El usuario es válido, pero no tiene permiso.
      return res.status(403).json({
        error: `Acceso denegado. El rol "${rol}" no tiene permiso para el módulo "${modulo}".`,
      });
    }

    // El usuario tiene el token válido Y el permiso correcto
    next();
  };
};
const jwt = require("jsonwebtoken");

exports.verificarPermiso = (permisoRequerido) => {
  return (req, res, next) => {
    try {
      // ⬇ OBTENER TOKEN
      const token = req.headers.authorization?.split(" ")[1];

      if (!token) {
        return res.status(401).json({ error: "Token no proporcionado" });
      }

      // ⬇ DECODIFICAR TOKEN
      const decoded = jwt.verify(token, process.env.JWT_SECRET || "secreto123");

      // ⬇ VALIDAR CAMPOS DEL TOKEN
      if (!decoded || !decoded.usuario) {
        return res.status(403).json({ error: "Token no contiene datos de usuario" });
      }

      if (!decoded.usuario.rol) {
        return res.status(403).json({ error: "Token no contiene rol del usuario" });
      }

      if (!decoded.usuario.permisos) {
        return res.status(403).json({ error: "Token no contiene permisos" });
      }

      // ⬇ GUARDAR USUARIO EN REQUEST
      req.usuario = decoded.usuario;

      // ⬇ VALIDAR SI TIENE PERMISO
      if (!req.usuario.permisos.includes(permisoRequerido)) {
        return res.status(403).json({ error: "No tiene permiso para esta acción" });
      }

      next();
    } catch (error) {
      console.error("❌ Error en permisosMiddleware:", error);
      return res.status(500).json({ error: "Error en permisosMiddleware" });
    }
  };
};
