const express = require("express");
const cors = require("cors");
require("dotenv").config();
const { poolPromise } = require("./config/db");

// Rutas
const activosRoutes = require("./routes/activosRoutes");
const monitoreoRoutes = require("./routes/monitoreoRoutes");
const responsablesRoutes = require("./routes/responsablesRoutes");
const simulacrosRoutes = require("./routes/simulacrosRoutes");
const incidentesRoutes = require("./routes/incidentesRoutes");
const usuariosRoutes = require("./routes/usuariosRoutes");
const caidasRoutes = require("./routes/caidasRoutes");
const dashboardRoutes = require("./routes/dashboardRoutes");
const reportesRoutes = require("./routes/reportesRoutes");
const authRoutes = require("./routes/authRoutes");

const app = express();
const PORT = process.env.PORT || 4000;

app.use(cors());
app.use(express.json());

// Rutas principales
app.use("/api/activos", activosRoutes);
app.use("/api/monitoreo", monitoreoRoutes);
app.use("/api/responsables", responsablesRoutes);
app.use("/api/simulacros", simulacrosRoutes);
app.use("/api/incidentes", incidentesRoutes);
app.use("/api/usuarios", usuariosRoutes);
app.use("/api/caidas", caidasRoutes);
app.use("/api/dashboard", dashboardRoutes);
app.use("/api/reportes", reportesRoutes);
app.use("/api/auth", authRoutes);

// Bypass test
app.get("/api/simulacros/test-direct", (_req, res) => res.send("direct ✅"));

app.get("/api", (_req, res) => {
  res.json({ ok: true, message: "API Continuidad TI funcionando ✅" });
});

(async () => {
  try { 
    await poolPromise; 
    console.log("✅ Conexión a SQL OK"); 
  }
  catch (err) { 
    console.error("❌ Error BD:", err); 
  }
})();

app.listen(PORT, () => {
  console.log(`🚀 Servidor en http://localhost:${PORT}`);
});
