// controllers/simulacrosController.js
const { poolPromise } = require('../config/db');

// Obtener todos los simulacros
exports.getSimulacros = async (req, res) => {
  try {
    const pool = await poolPromise;
    const result = await pool.request().query(`
      SELECT 
        s.id_simulacro,
        s.tipo_simulacro,
        s.fecha_programada,
        s.resultado,
        s.observaciones,
        s.responsable_id,
        u.nombre_completo AS responsable
      FROM Simulacros s
      LEFT JOIN Usuarios u ON s.responsable_id = u.id_usuario
      ORDER BY s.fecha_programada DESC;
    `);

    res.json(result.recordset);
  } catch (err) {
    console.error("❌ Error al obtener simulacros:", err);
    res.status(500).json({ ok: false, message: "Error al obtener simulacros" });
  }
};

// Crear simulacro
exports.createSimulacro = async (req, res) => {
  try {
    const { tipo_simulacro, fecha_programada, resultado, observaciones, responsable_id } = req.body;

    const pool = await poolPromise;
    await pool.request()
      .input('tipo_simulacro', tipo_simulacro)
      .input('fecha_programada', fecha_programada)
      .input('resultado', resultado || null)
      .input('observaciones', observaciones || null)
      .input('responsable_id', responsable_id || null)
      .query(`
        INSERT INTO Simulacros (tipo_simulacro, fecha_programada, resultado, observaciones, responsable_id)
        VALUES (@tipo_simulacro, @fecha_programada, @resultado, @observaciones, @responsable_id);
      `);

    res.json({ ok: true, message: "Simulacro creado correctamente" });

  } catch (err) {
    console.error("❌ Error al crear simulacro:", err);
    res.status(500).json({ ok: false, message: "Error al crear simulacro" });
  }
};

// Actualizar simulacro
exports.updateSimulacro = async (req, res) => {
  try {
    const { id } = req.params;
    const { tipo_simulacro, fecha_programada, resultado, observaciones, responsable_id } = req.body;

    const pool = await poolPromise;
    await pool.request()
      .input("id", id)
      .input("tipo_simulacro", tipo_simulacro)
      .input("fecha_programada", fecha_programada)
      .input("resultado", resultado)
      .input("observaciones", observaciones)
      .input("responsable_id", responsable_id)
      .query(`
        UPDATE Simulacros
        SET tipo_simulacro = @tipo_simulacro,
            fecha_programada = @fecha_programada,
            resultado = @resultado,
            observaciones = @observaciones,
            responsable_id = @responsable_id
        WHERE id_simulacro = @id
      `);

    res.json({ ok: true, message: "Simulacro actualizado correctamente" });

  } catch (err) {
    console.error("❌ Error al actualizar simulacro:", err);
    res.status(500).json({ ok: false, message: "Error al actualizar simulacro" });
  }
};

// Eliminar simulacro
exports.deleteSimulacro = async (req, res) => {
  try {
    const { id } = req.params;

    const pool = await poolPromise;
    await pool.request()
      .input("id", id)
      .query(`DELETE FROM Simulacros WHERE id_simulacro = @id`);

    res.json({ ok: true, message: "Simulacro eliminado correctamente" });

  } catch (err) {
    console.error("❌ Error al eliminar simulacro:", err);
    res.status(500).json({ ok: false, message: "Error al eliminar simulacro" });
  }
};
