const sql = require('mssql');
require('dotenv').config();

const dbConfig = {
  user: process.env.DB_USER,
  password: process.env.DB_PASSWORD,
  server: process.env.DB_SERVER,
  database: process.env.DB_DATABASE,
  port: parseInt(process.env.DB_PORT),
  options: {
    encrypt: true,                  // Requerido en Azure
    enableArithAbort: true,
    trustServerCertificate: true,   // ✅ Permite certificados autofirmados
  },
};

const poolPromise = new sql.ConnectionPool(dbConfig)
  .connect()
  .then((pool) => {
    console.log('✅ Conectado correctamente a Azure SQL Database');
    return pool;
  })
  .catch((err) => {
    console.error('❌ Error al conectar a Azure SQL Database:', err);
  });

module.exports = { sql, poolPromise };
